/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api.event;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.AnimationType;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.event.AnimationEventType;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.event.IAnimationEventSerializer;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.AbstractAnimationEvent;
import lib.toma.animations.engine.ByteFlags;
import lib.toma.animations.engine.screen.animator.dialog.EventCreateDialog;
import lib.toma.animations.engine.screen.animator.dialog.EventDialogContext;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import lib.toma.animations.engine.screen.animator.widget.ListView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;

public class PlayAnimationEvent
extends AbstractAnimationEvent {
    private final AnimationType<?> type;
    private final int playDelay;

    public PlayAnimationEvent(float target, AnimationType<?> type) {
        this(target, type, 0);
    }

    public PlayAnimationEvent(float target, AnimationType<?> type, int playDelay) {
        this(AnimationEventType.PLAY_ANIMATION, target, type, playDelay);
    }

    protected PlayAnimationEvent(AnimationEventType<? extends PlayAnimationEvent> eventType, float target, AnimationType<?> type, int playDelay) {
        super(eventType, target);
        this.type = type;
        this.playDelay = playDelay;
        Preconditions.checkState((boolean)type.hasCreator(), (Object)"This type doesn't have custom animation creator!");
    }

    @Override
    public void dispatch(Minecraft client, IAnimation fromAnimation) {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        if (this.playDelay == 0) {
            pipeline.insert(this.type);
        } else {
            pipeline.scheduleInsert(this.type, this.playDelay);
        }
    }

    @Override
    public IAnimationEvent copyAt(float target) {
        return new PlayAnimationEvent(target, this.type, this.playDelay);
    }

    public static class AddPlayAnimationEventDialog
    extends EventCreateDialog<PlayAnimationEvent> {
        private final Pattern delayPattern = Pattern.compile("0|([1-9][0-9]{0,2})");
        private final ByteFlags errorHandler = new ByteFlags(0);
        private TextFieldWidget playDelay;
        private AnimationType<?> selectedType;

        public AddPlayAnimationEventDialog(EventDialogContext<PlayAnimationEvent> context) {
            super(context);
            this.setDimensions(175, 145);
        }

        @Override
        protected PlayAnimationEvent construct() {
            EventDialogContext context = this.getContext();
            return new PlayAnimationEvent(context.getTarget(), this.selectedType, Integer.parseInt(this.playDelay.func_146179_b()));
        }

        @Override
        protected void addWidgets() {
            int elementWidth = this.dWidth() - 10;
            int buttonWidth = (elementWidth - 5) / 2;
            ListView availableTypes = (ListView)this.func_230480_a_(new ListView<AnimationType>(this.left() + 5, this.top() + 15, elementWidth, 75, Registries.ANIMATION_TYPES.values(), AnimationType::hasCreator));
            availableTypes.setResponder(this::select);
            availableTypes.setFormatter(type -> type.getKey().toString());
            this.playDelay = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 95, elementWidth, 20, StringTextComponent.field_240750_d_));
            this.playDelay.func_212954_a((Consumer)new SuggestionResponder("Delay [ticks]", this.playDelay, this::playDelay_changed));
            this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 120, buttonWidth, 20, CANCEL, this::cancel_clicked));
            this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + buttonWidth, this.top() + 120, buttonWidth, 20, CONFIRM, this::confirm_clicked));
            this.updateConfirmButton();
        }

        private void select(AnimationType<?> type) {
            this.selectedType = type;
            if (type != null) {
                this.errorHandler.clear(0);
            } else {
                this.errorHandler.set(0);
            }
        }

        private void playDelay_changed(String value) {
            if (this.delayPattern.matcher(value).matches()) {
                this.errorHandler.clear(1);
                this.playDelay.func_146193_g(0xE0E0E0);
            } else {
                this.errorHandler.set(1);
                this.playDelay.func_146193_g(0xE00000);
            }
            this.updateConfirmButton();
        }

        private void updateConfirmButton() {
            if (this.confirm != null) {
                this.confirm.field_230693_o_ = this.errorHandler.isEmpty();
            }
        }
    }

    public static final class Serializer
    implements IAnimationEventSerializer<PlayAnimationEvent> {
        @Override
        public JsonElement serialize(PlayAnimationEvent event, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("key", event.type.getKey().toString());
            if (event.playDelay > 0) {
                object.addProperty("delay", (Number)event.playDelay);
            }
            return object;
        }

        @Override
        public PlayAnimationEvent deserialize(float target, JsonElement src, JsonDeserializationContext context) {
            if (!src.isJsonObject()) {
                throw new JsonSyntaxException("Not a Json object!");
            }
            JsonObject object = src.getAsJsonObject();
            ResourceLocation location = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"key"));
            AnimationType<?> type = Registries.ANIMATION_TYPES.getElement(location);
            if (type == null) {
                throw new JsonSyntaxException("Unknown animation type: " + location);
            }
            int delay = JSONUtils.func_151208_a((JsonObject)object, (String)"delay", (int)0);
            return new PlayAnimationEvent(target, type, delay);
        }
    }
}

